
#ifndef THPMD_H
#define THPMD_H

#include <limits.h>

typedef unsigned char u8;

#define U16_MAX 0xFFFFU
#if USHRT_MAX == U16_MAX
typedef unsigned short u16;
#elif UINT_MAX == U16_MAX
typedef unsigned int u16;
#elif ULONG_MAX == U16_MAX
typedef unsigned long u16;
#else
#error "can't compile in this environment"
#endif

#define U32_MAX 0xFFFFFFFFUL
#if USHRT_MAX == U32_MAX
typedef unsigned short u32;
#elif UINT_MAX == U32_MAX
typedef unsigned int u32;
#elif ULONG_MAX == U32_MAX
typedef unsigned long u32;
#else
#error "can't compile in this environment"
#endif

#define isfchr(c) ((c)>=' '&&(c)!='+'&&(c)!=','&&(c)!=';'&&(c)!='='&&(c)!='['&&(c)!=']'&&(c)!='.')

#define to16le(b) ((b)[0]|((u16)(b)[1]<<8))
#define to32le(b) (to16le(b)|((u32)to16le(b+2)<<16))

#endif
